setwd("<your directory or folder path>")
df1 <- read.csv("20191007 Example 14.2 One Way with Ranks.csv")
#
# df1 has the following columns:
#
# Y
# Group
#
# Note:  Y was simulated so that:
# Group 1 Gamma(shape=2.0,scale=5.0)
# Group 2 Gamma(shape=2.0,scale=5.1)
# Group 3 Gamma(shape=2.4,scale=5.6)

#
# n = 20 in all groups
#
# 
#
library(dplyr) #has some nice functions for computing groupwise
#               descriptive statistics
#
rank.comp <- rank(df1$Y)#this computes the ranks of all the data, 
#                        ordered from smallest to largest without 
#                        regard to Group
#
df2 <- cbind(df1,rank.comp)#combines the Rank column, rank.comp, with the Group variable
attach(df2)
group_by(df2,Group)%>%
summarise(count=n(),mean=mean(Y),sd=sd(Y))
#
group_by(df2,Group)%>%
summarise(count=n(),mean=mean(rank.comp),sd=sd(rank.comp))

summary(aov(Y ~ Group))
summary(aov(rank.comp ~ Group))
kw <- kruskal.test(Y ~ Group)
boxplot(Y ~ Group,main="Boxplots of Y by Group",xlab="Group",ylab="Y (natural units)")
dev.new()
boxplot(rank.comp ~ Group,main="Boxplots of Ranks by Group",xlab="Group",ylab="Rank of Y")
